/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.MACAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.CommandStatus;
import com.cisco.pt.ipc.sim.CiscoDevice;
import com.cisco.pt.ipc.sim.TerminalLine;
import com.cisco.pt.ipc.sim.impl.DeviceImpl;
import com.cisco.pt.ipc.sim.port.Port;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiscoDeviceImpl
extends DeviceImpl
implements CiscoDevice {
    public CiscoDeviceImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public void setHostName(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setHostName");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getHostName() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getHostName");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setEnableSecret(String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnableSecret");
        newCall.addStringParameter(password);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getEnableSecret() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEnableSecret");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setEnablePassword(String password, int level) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnablePassword");
        newCall.addStringParameter(password);
        newCall.addIntParameter(level);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getEnablePassword() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEnablePassword");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setStartupFile(String str) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setStartupFile");
        newCall.addStringParameter(str);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public List<String> getStartupFile() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStartupFile");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public boolean addBootSystem(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addBootSystem");
        newCall.addStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CiscoDeviceImpl.addBootSystem");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean removeBootSystem(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeBootSystem");
        newCall.addStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CiscoDeviceImpl.removeBootSystem");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void removeAllBootSystem() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeAllBootSystem");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public List<String> getBootSystems() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBootSystems");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<String> answer = new ArrayList<String>();
        for (Object o : rawList) {
            answer.add((String)o);
        }
        return answer;
    }

    @Override
    public Short getConfigRegister() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfigRegister");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return returnMessage.getShortValue();
    }

    @Override
    public void setNextConfigRegister(Short in_register) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setNextConfigRegister");
        newCall.addShortParameter(in_register);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public Short getNextConfigRegister() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getNextConfigRegister");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return returnMessage.getShortValue();
    }

    @Override
    public void setBannerMotd(String banner) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setBannerMotd");
        newCall.addStringParameter(banner);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getBannerMotd() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBannerMotd");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void setTimeZone(String timeZone, Short hourOffset, Short minOffset) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setTimeZone");
        newCall.addStringParameter(timeZone);
        newCall.addShortParameter(hourOffset);
        newCall.addShortParameter(minOffset);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getTimeZone() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTimeZone");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public MACAddress getBia() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getBia");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (MACAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setServicePasswordEncryption(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setServicePasswordEncryption");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean getServicePasswordEncryption() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getServicePasswordEncryption");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: CiscoDeviceImpl.getServicePasswordEncryption");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public Port getConsole() {
        return this.getFactory().getConsole(this);
    }

    @Override
    public TerminalLine getConsoleLine() {
        return this.getFactory().getConsoleLine(this);
    }

    @Override
    public TerminalLine getVtyLine(int num) {
        return this.getFactory().getVtyLine(this, num);
    }

    @Override
    public TerminalLine getLine(int num) {
        return this.getFactory().getLine(this, num);
    }

    @Override
    public TerminalLine getIpcTerminalLine() {
        return this.getFactory().getIpcTerminalLine(this);
    }

    @Override
    public Pair<CommandStatus, String> enterCommand(String commandStr, String modeStr) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("enterCommand");
        newCall.addStringParameter(commandStr);
        newCall.addStringParameter(modeStr);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<CommandStatus, String> answer = new Pair<CommandStatus, String>(CommandStatus.fromIntValue((Integer)rawPair.getFirst()), (String)rawPair.getSecond());
        return answer;
    }

    @Override
    public void skipBoot() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("skipBoot");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setFtpUsername(String username) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFtpUsername");
        newCall.addStringParameter(username);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setFtpPasswd(String passwd, int uType) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFtpPasswd");
        newCall.addStringParameter(passwd);
        newCall.addIntParameter(uType);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public String getFtpUsername() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFtpUsername");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public String getFtpPasswd() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFtpPasswd");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public void clearFtpUsername() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearFtpUsername");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void clearFtpPasswd() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearFtpPasswd");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

